<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\AffiliateWP\Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get the user's affiliate ID
 *
 * @since 1.0.0
 *
 * @param int $user_id
 *
 * @return bool|int
 */
function automatorwp_affiliatewp_get_user_affiliate_id( $user_id ) {

    $customer_id = absint( affiliate_wp()->customers->get_column_by( 'customer_id', 'user_id', $user_id ) );

    if( $customer = affwp_get_customer( $customer_id ) ) {

        return $customer->get_canonical_affiliate_id();

    }

    return false;

}